/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.taskman;

import filenet.vw.api.VWException;
import filenet.vw.apps.taskman.VWTaskActionCommand;
import filenet.vw.apps.taskman.VWTaskApplicationSettings;
import filenet.vw.apps.taskman.VWTaskBaseNode;
import filenet.vw.apps.taskman.VWTaskCore;
import filenet.vw.apps.taskman.VWTaskDefaultTableModel;
import filenet.vw.apps.taskman.VWTaskFolderNode;
import filenet.vw.apps.taskman.VWTaskProperties;
import filenet.vw.apps.taskman.VWTaskRootPropertyPanel;
import filenet.vw.apps.taskman.VWTaskTablePanel;
import filenet.vw.apps.taskman.VWTaskXMLHandler;
import filenet.vw.apps.taskman.images.VWImageLoader;
import filenet.vw.apps.taskman.integrator.VWCMAdminNode;
import filenet.vw.apps.taskman.pa.PANode;
import filenet.vw.apps.taskman.resources.VWResource;
import filenet.vw.apps.taskman.router.VWRouterAdminNode;
import filenet.vw.apps.taskman.rules.VWRulesNode;
import filenet.vw.apps.taskman.sim.VWSimEngineNode;
import filenet.vw.base.VWDebug;
import filenet.vw.base.VWString;
import filenet.vw.base.logging.Level;
import filenet.vw.base.logging.VWConsoleHandler;
import filenet.vw.toolkit.utils.VWStringUtils;
import java.awt.event.ActionEvent;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.ImageIcon;
import javax.swing.tree.TreeNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class VWTaskRootNode
extends VWTaskBaseNode {
    private static final long serialVersionUID = 7476L;
    VWTaskApplicationSettings m_appSettings = null;
    VWTaskRootPropertyPanel m_propertyPanel = null;
    VWTaskTablePanel m_tablePanel = null;
    boolean m_nodesAdded = false;
    int m_registryPort = 32771;
    HashMap m_missingNodeXML = new HashMap();
    boolean m_bRefreshing = false;
    String m_localHost = null;
    protected static final ImageIcon nodeIcon32 = VWImageLoader.createImageIcon("folder_c_32.gif");
    protected static final ImageIcon nodeIcon16 = VWImageLoader.createImageIcon("folder_c_16.gif");
    private static final int[] AUTO_START_STOP_TASKS = new int[]{6, 21, 18, 20, 22};
    private static String m_hostName = "LocalHost";

    public VWTaskRootNode(VWTaskApplicationSettings appSettings) throws Exception {
        super(m_hostName, 1);
        this.setPropertyFilePath(appSettings.getDefaultPropertiesPath());
        this.setIcon32(nodeIcon32);
        this.setIcon16(nodeIcon16);
        this.fromXML(appSettings.getXMLHandler());
        this.m_appSettings = appSettings;
        if (!VWTaskCore.getInstance().isAutoMode()) {
            if (appSettings.getProperties().getBoolean("TaskManager.ProcessService")) {
                this.m_tablePanel = new VWTaskTablePanel(new VWTaskDefaultTableModel(this));
                this.getContentPane().setTablePanel(this.m_tablePanel);
            } else {
                this.m_propertyPanel = new VWTaskRootPropertyPanel(this);
                this.getContentPane().setPropertyPanel(this.m_propertyPanel, true, false);
            }
            VWConsoleHandler.installGlobalHandler();
            this.setConsoleHandler(VWConsoleHandler.getGlobalHandler());
        }
    }

    public void writeMessage(Level logLevel, String message) {
        if (!VWTaskCore.getInstance().isAutoMode()) {
            VWTaskBaseNode selectedNode = VWTaskCore.getInstance().getSelectedNode();
            if (selectedNode != this && !this.m_bRefreshing) {
                selectedNode.writeMessage(logLevel, message);
            } else {
                super.writeMessage(logLevel, message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        try {
            this.m_bRefreshing = true;
            if (!this.m_nodesAdded || this.m_missingNodeXML.size() > 0) {
                ArrayList<VWTaskBaseNode> folderNodes = new ArrayList<VWTaskBaseNode>();
                HashMap propsMap = VWTaskApplicationSettings.getInstance().getPropertiesMap();
                for (String propsPath : propsMap.keySet()) {
                    if (VWTaskApplicationSettings.getInstance().getXMLHandler(propsPath) == null) continue;
                    VWTaskProperties props = (VWTaskProperties)propsMap.get(propsPath);
                    String productId = props.getProperty("TaskManager.ProductID");
                    if (productId == null) {
                        productId = propsPath;
                    }
                    try {
                        VWTaskBaseNode node = this;
                        if (productId.equals("TaskManager.AE")) {
                            node = this.findChildNode(VWResource.ApplicationEngine);
                            if (node == null) {
                                node = new VWTaskFolderNode(VWResource.ApplicationEngine, propsPath);
                                node.setExpandAtStartup(true);
                                folderNodes.add(node);
                            }
                        } else if (productId.equals("TaskManager.WPXT") && (node = this.findChildNode(VWResource.ApplicationEngineWPXT)) == null) {
                            node = new VWTaskFolderNode(VWResource.ApplicationEngineWPXT, propsPath);
                            node.setExpandAtStartup(true);
                            folderNodes.add(node);
                        }
                        if (props.getBoolean("TaskManager.ProcessService")) {
                            String xmlNodeName = null;
                            try {
                                Class<?> wfNodeClass = Class.forName("filenet.jpe.ptm.VWWorkflowServicesNode");
                                Object wfServiceNode = wfNodeClass.newInstance();
                                xmlNodeName = (String)wfNodeClass.getField("XML_NODE_NAME").get(null);
                                if (node.findChildNode(6) == null) {
                                    this.add((VWTaskBaseNode)wfServiceNode);
                                    this.removeMissingNodeXML(xmlNodeName, propsPath);
                                }
                            }
                            catch (Exception e) {
                                this.storeMissingNodeXML(xmlNodeName, propsPath);
                                this.displayRefreshError(e);
                                VWDebug.logException(e, "Error creating Process Service node.");
                            }
                        }
                        if (props.getBoolean("TaskManager.RulesEngine")) {
                            try {
                                if (node.findChildNode(21) == null) {
                                    node.add(new VWRulesNode(propsPath));
                                    this.removeMissingNodeXML("RulesEngine", propsPath);
                                }
                            }
                            catch (Exception e) {
                                this.storeMissingNodeXML("RulesEngine", propsPath);
                                this.displayRefreshError(e);
                                VWDebug.logException(e, "Error creating Rules Listener node.");
                            }
                        }
                        if (props.getBoolean("TaskManager.ComponentManager")) {
                            try {
                                if (node.findChildNode(18) == null) {
                                    node.add(new VWCMAdminNode(propsPath));
                                    this.removeMissingNodeXML("ComponentManagers", propsPath);
                                }
                            }
                            catch (Exception e) {
                                this.storeMissingNodeXML("ComponentManagers", propsPath);
                                this.displayRefreshError(e);
                                VWDebug.logException(e, "Error creating Component Manager node.");
                            }
                        }
                        if (props.getBoolean("TaskManager.ProcessSimulator")) {
                            try {
                                if (node.findChildNode(20) == null) {
                                    node.add(new VWSimEngineNode(propsPath));
                                    this.removeMissingNodeXML("ProcessSimulator", propsPath);
                                }
                            }
                            catch (Exception e) {
                                this.storeMissingNodeXML("ProcessSimulator", propsPath);
                                this.displayRefreshError(e);
                                VWDebug.logException(e, "Error creating Process Optimizer node.");
                            }
                        }
                        if (props.getBoolean("TaskManager.CaseAnalyzer")) {
                            try {
                                if (node.findChildNode(22) == null) {
                                    node.add(new PANode(propsPath));
                                    this.removeMissingNodeXML("CaseAnalyzer", propsPath);
                                }
                            }
                            catch (Exception e) {
                                this.storeMissingNodeXML("CaseAnalyzer", propsPath);
                                this.displayRefreshError(e);
                                VWDebug.logException(e, "Error creating Case Analyzer node.");
                            }
                        }
                        if (!props.getBoolean("TaskManager.Router") || !productId.equals("TaskManager.AE") && !productId.equals("Taskmanager.WPXT")) continue;
                        try {
                            if (node.findChildNode(4) != null) continue;
                            node.add(new VWRouterAdminNode(propsPath));
                            this.removeMissingNodeXML("RouterAdminNode", propsPath);
                        }
                        catch (Exception e) {
                            this.storeMissingNodeXML("RouterAdminNode", propsPath);
                            this.displayRefreshError(e);
                            VWDebug.logException(e, "Error creating Router Admin node.");
                        }
                    }
                    catch (Exception e) {
                        this.displayRefreshError(e);
                        VWDebug.logException(e, "Error while initializing product: " + productId);
                    }
                }
                Iterator<Object> i = folderNodes.iterator();
                while (i.hasNext()) {
                    this.add((VWTaskBaseNode)i.next());
                }
                this.m_nodesAdded = true;
                this.getTaskCore().updateApplicationFile();
            }
            this.refreshChildren();
            if (this.m_propertyPanel != null) {
                this.m_propertyPanel.refresh();
            }
            if (this.m_tablePanel != null) {
                this.m_tablePanel.refresh();
            }
        }
        finally {
            this.m_bRefreshing = false;
        }
    }

    public HashMap toXML(StringBuffer xmlHeader, String xmlFooter) throws VWException {
        String ATTRIB_INDENT = "\t\t";
        HashMap<String, StringBuffer> xmlMap = new HashMap<String, StringBuffer>();
        xmlHeader.append("\t<Root ");
        xmlHeader.append("RegistryPort=\"" + this.m_registryPort + "\"");
        if (this.m_localHost != null && !this.m_localHost.equals("")) {
            xmlHeader.append(" LocalHost=\"" + this.m_localHost + "\"");
        }
        xmlHeader.append("/>\n");
        Enumeration<TreeNode> e = this.children();
        while (e.hasMoreElements()) {
            VWTaskBaseNode node = (VWTaskBaseNode)e.nextElement();
            String xmlPath = this.m_appSettings.getXMLPath(node.getPropertyFilePath());
            StringBuffer buffer = (StringBuffer)xmlMap.get(xmlPath);
            if (buffer == null) {
                buffer = new StringBuffer(xmlHeader.toString());
                xmlMap.put(xmlPath, buffer);
            }
            node.toXML(buffer);
        }
        if (this.m_missingNodeXML.size() > 0) {
            for (String xmlPath : this.m_missingNodeXML.keySet()) {
                StringBuffer buffer = (StringBuffer)xmlMap.get(xmlPath);
                HashMap xmlNodeMap = (HashMap)this.m_missingNodeXML.get(xmlPath);
                for (String xml : xmlNodeMap.values()) {
                    buffer.append(xml);
                }
            }
        }
        Iterator<Object> i = xmlMap.values().iterator();
        while (i.hasNext()) {
            ((StringBuffer)i.next()).append(xmlFooter);
        }
        return xmlMap;
    }

    public void setRegistryPort(int port) {
        this.m_registryPort = port;
    }

    public int getRegistryPort() {
        return this.m_registryPort;
    }

    public void setLocalHost(String localHost) {
        this.m_localHost = localHost;
    }

    public String getLocalHost() {
        return this.m_localHost;
    }

    public String[] getActions() {
        String[] actions = new String[]{VWTaskActionCommand.HELP};
        return actions;
    }

    public boolean isActionEnabled(String actionCMD) {
        return true;
    }

    public void actionPerformed(ActionEvent event) {
        String actionCMD = event.getActionCommand();
        try {
            if (VWStringUtils.compare(actionCMD, VWTaskActionCommand.REFRESH) == 0) {
                this.refresh();
            } else if (VWStringUtils.compare(actionCMD, VWTaskActionCommand.HELP) == 0) {
                this.displayHelp();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void fromXML(VWTaskXMLHandler xmlHandler) {
        block8: {
            try {
                if (xmlHandler == null) {
                    return;
                }
                Node node = VWTaskXMLHandler.getNodeNamed(xmlHandler.getRootNode(), "Root");
                if (node == null || node.getNodeType() != 1) {
                    return;
                }
                Element ele = (Element)node;
                try {
                    if (ele.getAttributeNode("RegistryPort") != null) {
                        this.setRegistryPort(Integer.parseInt(ele.getAttribute("RegistryPort")));
                    }
                    if (ele.getAttributeNode("LocalHost") != null) {
                        this.setLocalHost(ele.getAttribute("LocalHost"));
                        break block8;
                    }
                    this.setLocalHost(this.getProperty("TaskManager.Host", null));
                }
                catch (NumberFormatException e) {}
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void autoStartTasks() throws Exception {
        this.refresh();
        StringBuffer errorBuffer = new StringBuffer();
        for (int i = 0; i < AUTO_START_STOP_TASKS.length; ++i) {
            VWTaskBaseNode[] nodes = this.findChildNodes(AUTO_START_STOP_TASKS[i], null, true);
            if (nodes == null) continue;
            for (int j = 0; j < nodes.length; ++j) {
                VWTaskBaseNode node = nodes[j];
                if (!node.getAutoStartEnabled()) continue;
                try {
                    System.out.println(new VWString("filenet.vw.apps.taskman.VWTaskRootNode.StartingTask", "Starting {0}...").toString(node.getName()));
                    node.start();
                    continue;
                }
                catch (Exception ex) {
                    StringWriter sw = new StringWriter();
                    ex.printStackTrace(new PrintWriter(sw));
                    errorBuffer.append(new VWString("filenet.vw.apps.taskman.VWTaskRootNode.UnableToStartTask", "Unable to start task {0}: {1}\n\n").toString(node.getName(), sw.toString()));
                }
            }
        }
        if (errorBuffer.length() > 0) {
            throw new Exception(errorBuffer.toString());
        }
        System.out.println(new VWString("filenet.vw.apps.taskman.VWTaskRootNode.StartingSoftareCompleted", "Startup of software completed.").toString());
    }

    protected void autoStopTasks() throws Exception {
        this.refresh();
        StringBuffer errorBuffer = new StringBuffer();
        for (int i = AUTO_START_STOP_TASKS.length - 1; i >= 0; --i) {
            VWTaskBaseNode[] nodes = this.findChildNodes(AUTO_START_STOP_TASKS[i], null, true);
            if (nodes == null) continue;
            for (int j = 0; j < nodes.length; ++j) {
                VWTaskBaseNode node = nodes[j];
                try {
                    System.out.println(new VWString("filenet.vw.apps.taskman.VWTaskRootNode.StoppingTask", "Stopping {0}...").toString(node.getName()));
                    node.stop();
                    continue;
                }
                catch (Exception ex) {
                    StringWriter sw = new StringWriter();
                    ex.printStackTrace(new PrintWriter(sw));
                    errorBuffer.append(new VWString("filenet.vw.apps.taskman.VWTaskRootNode.UnableToStopTask", "Unable to stop task {0}: {1}\n\n").toString(node.getName(), sw.toString()));
                }
            }
        }
        if (errorBuffer.length() > 0) {
            throw new Exception(errorBuffer.toString());
        }
        System.out.println(new VWString("filenet.vw.apps.taskman.VWTaskRootNode.TerminationOfSoftareCompleted", "Termination of software completed.").toString());
    }

    private void displayRefreshError(Exception e) {
        if (!VWTaskCore.getInstance().isAutoMode()) {
            this.displayError(e);
        }
    }

    private void storeMissingNodeXML(String nodeName, String propertyFilePath) {
        String xmlPath = this.m_appSettings.getXMLPath(propertyFilePath);
        VWTaskXMLHandler xmlHandler = VWTaskCore.getInstance().getXMLHandler(propertyFilePath);
        String xml = xmlHandler.getXMLForTopLevelNode(nodeName);
        HashMap<String, String> xmlNodeMap = (HashMap<String, String>)this.m_missingNodeXML.get(xmlPath);
        if (xmlNodeMap == null) {
            xmlNodeMap = new HashMap<String, String>();
            this.m_missingNodeXML.put(xmlPath, xmlNodeMap);
        }
        xmlNodeMap.put(nodeName, xml);
    }

    private void removeMissingNodeXML(String nodeName, String propertyFilePath) {
        String xmlPath = this.m_appSettings.getXMLPath(propertyFilePath);
        HashMap xmlNodeMap = (HashMap)this.m_missingNodeXML.get(xmlPath);
        if (xmlNodeMap != null) {
            xmlNodeMap.remove(nodeName);
            if (xmlNodeMap.size() == 0) {
                this.m_missingNodeXML.remove(xmlPath);
            }
        }
    }

    public static String _get_FILE_DATE() {
        return "$Date:   16 May 2007 10:49:36  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   qdang  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.42  $";
    }

    static {
        try {
            m_hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

